/*
 * OOUtils.java
 *
 * Created on February 22, 2003, 12:10 PM
 *
 * Copyright 2003 Danny Brewer
 * Anyone may run this code.
 * If you wish to modify or distribute this code, then
 *  you are granted a license to do so only under the terms
 *  of the Gnu Lesser General Public License.
 * See:  http://www.gnu.org/licenses/lgpl.html
 */

package nom.DannyBrewer.OOoUno;

import nom.DannyBrewer.utils.ExceptionHandler;


//----------------------------------------------------------------------
//  UNO imports
//----------------------------------------------------------------------

// base of all interfaces
import com.sun.star.uno.XInterface;

// access the implementations via names
import com.sun.star.comp.servicemanager.ServiceManager;


import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.connection.XConnector;
import com.sun.star.connection.XConnection;

import com.sun.star.bridge.XUnoUrlResolver;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.uno.XNamingService;
import com.sun.star.uno.XComponentContext;


//----------------------------------------------------------------------
//  OpenOffice.org imports
//----------------------------------------------------------------------

// staroffice interfaces to provide desktop and componentloader
// and components i.e. spreadsheets, writerdocs etc.
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XComponentLoader;

// additional classes required
import com.sun.star.sheet.*;
import com.sun.star.container.*;
import com.sun.star.table.*;
import com.sun.star.beans.*;
import com.sun.star.style.*;
import com.sun.star.lang.*;
import com.sun.star.drawing.*;
import com.sun.star.text.XText;
import com.sun.star.awt.*;



/**
 *
 * @author  danny brewer
 */
public class OOUtils {
    private OOUtils() { }
    
    
    //----------------------------------------------------------------------
    //  Get remote service manager.
    //	This is the first object you need to connect to a
    //	 running instance of OpenOffice.org.
    //----------------------------------------------------------------------
    
    public final static String LOCAL_OO_SERVICE_MGR_URL = "uno:socket,host=localhost,port=8100;urp;StarOffice.ServiceManager";
    
    
    // Connect to OpenOffice's ServiceManager, port 8100, localhost.
    public static Object getOORemoteServiceManager()
            throws	java.lang.Exception,
                        com.sun.star.uno.Exception,
                        com.sun.star.connection.NoConnectException,
                        com.sun.star.beans.UnknownPropertyException {
        return getOORemoteServiceManager( LOCAL_OO_SERVICE_MGR_URL );
    }
    
    
    // Connect to OpenOffice's ServiceManager, port 8100, localhost.
    public static Object getOORemoteServiceManager( String host, String port )
            throws	java.lang.Exception,
                        com.sun.star.uno.Exception,
                        com.sun.star.connection.NoConnectException,
                        com.sun.star.beans.UnknownPropertyException {
        return getOORemoteServiceManager( "uno:socket,host=" + host + ",port=" + port + ";urp;StarOffice.ServiceManager" );
    }
    
    
    // Connect to a specified URL to get a remote service manager.
    public static Object getOORemoteServiceManager( String unoRemoteServiceManagerUrl )
            throws	java.lang.Exception,
                        com.sun.star.uno.Exception,
                        com.sun.star.connection.NoConnectException,
                        com.sun.star.beans.UnknownPropertyException {
        // Create a local component context.
        XComponentContext xLocalContext =
        com.sun.star.comp.helper.Bootstrap.createInitialComponentContext( null );
        
        // Get the local service manager from the local component context.
        XMultiComponentFactory xLocalServiceManager = xLocalContext.getServiceManager();
        
        // Ask local service manager for a UnoUrlResolver object with an XUnoUrlResolver interface.
        Object unoUrlResolver =
        xLocalServiceManager.createInstanceWithContext( "com.sun.star.bridge.UnoUrlResolver", xLocalContext );
        
        // Query the UnoUrlResolver object for an XUnoUrlResolver interface.
        XUnoUrlResolver xUnoUrlResolver =
        (XUnoUrlResolver) UnoRuntime.queryInterface( XUnoUrlResolver.class, unoUrlResolver );
        
        // Use the xUnoUrlResolver interface to get a remote service manager,
        //  by resolving the URL that was passed in as a parameter.
        Object xRemoteServiceManager = xUnoUrlResolver.resolve( unoRemoteServiceManagerUrl );
        //UnoUtils.printService( xRemoteServiceManager );
        
        return xRemoteServiceManager;
    }
    
    
    
    //----------------------------------------------------------------------
    //  Property Manipulation
    //----------------------------------------------------------------------
    
    public static void setIntProperty( Object obj, String propName, int value ) {
        setProperty( obj, propName, new Integer( value ) );
    }
    
    public static int getIntProperty( Object obj, String propName ) {
        Object value = getProperty( obj, propName );
        if( value != null ) {
            if( value instanceof Integer ) {
                Integer intValue = (Integer) value;
                return intValue.intValue();
            }
        }
        return 0;
    }
    
    
    public static void setBooleanProperty( Object obj, String propName, boolean value ) {
        setProperty( obj, propName, new Boolean( value ) );
    }
    
    public static boolean getBooleanProperty( Object obj, String propName ) {
        Object value = getProperty( obj, propName );
        if( value != null ) {
            if( value instanceof Boolean ) {
                Boolean booleanValue = (Boolean) value;
                return booleanValue.booleanValue();
            }
        }
        return false;
    }
    
    
    public static void setStringProperty( Object obj, String propName, String value ) {
        setProperty( obj, propName, value );
    }
    
    public static String getStringProperty( Object obj, String propName ) {
        Object value = getProperty( obj, propName );
        if( value != null ) {
            if( value instanceof String ) {
                String stringValue = (String) value;
                return stringValue;
            }
        }
        return "";
    }
    
    
    public static void setProperty( Object obj, String propName, Object value ) {
        // We need the XPropertySet interface.
        XPropertySet obj_XPropertySet;
        if( obj instanceof XPropertySet ) {
            // If the right interface was passed in, just typecaset it.
            obj_XPropertySet = (XPropertySet) obj;
        } else {
            // Get a different interface to the drawDoc.
            // The parameter passed in to us is the wrong interface to the object.
            obj_XPropertySet = QueryInterface.XPropertySet( obj );
        }
        
        // Now just call our sibling using the correct interface.
        setProperty( obj_XPropertySet, propName, value );
    }
    
    public static void setProperty( XPropertySet obj, String propName, Object value ) {
        try {
            obj.setPropertyValue( propName, value );
        }
        catch( com.sun.star.beans.UnknownPropertyException e ) {
            ExceptionHandler.unexpectedException( e );
        }
        catch( com.sun.star.beans.PropertyVetoException e ) {
            ExceptionHandler.unexpectedException( e );
        }
        catch( com.sun.star.lang.IllegalArgumentException e ) {
            ExceptionHandler.unexpectedException( e );
        }
        catch( com.sun.star.lang.WrappedTargetException e ) {
            ExceptionHandler.unexpectedException( e );
        }
    }
    
    
    public static Object getProperty( Object obj, String propName ) {
        // We need the XPropertySet interface.
        XPropertySet obj_XPropertySet;
        if( obj instanceof XPropertySet ) {
            // If the right interface was passed in, just typecaset it.
            obj_XPropertySet = (XPropertySet) obj;
        } else {
            // Get a different interface to the drawDoc.
            // The parameter passed in to us is the wrong interface to the object.
            obj_XPropertySet = QueryInterface.XPropertySet( obj );
        }
        
        // Now just call our sibling using the correct interface.
        return getProperty( obj_XPropertySet, propName );
    }
    
    public static Object getProperty( XPropertySet obj, String propName ) {
        try {
            return obj.getPropertyValue( propName );
        }
        catch( com.sun.star.beans.UnknownPropertyException e ) {
            ExceptionHandler.unexpectedException( e );
        }
        catch( com.sun.star.lang.WrappedTargetException e ) {
            ExceptionHandler.unexpectedException( e );
        }
        return null;
    }
    
    
}
